/* MT7687 SPI IOT Linux driver */

/* 
 * Copyright (c) 2017 MSTAR Corporation
 * Authur: Vincent Chen
*/
 
#include <linux/platform_device.h>


#include <linux/slab.h>
#include <linux/firmware.h>
#include <linux/delay.h>
#include <linux/mmc/card.h>
#include <linux/mmc/host.h>
#include <linux/mmc/sdio_func.h>
#include <linux/mmc/sdio_ids.h>
#include <linux/module.h>

#include <linux/semaphore.h>

#include <linux/skbuff.h>
#include <linux/ip.h>

#include <linux/netdevice.h>
#include <linux/gpio.h>

#include "iot_ether.h"
#include "iot_ctrl.h"
#include "iot_api.h"
#include "sdio_reg.h"
#include "mt7682_sdio.h"


#define ENABLE_RX1_INTERRUPT

uint32_t slt_msdc_tx_buf[128 * SLT_TEST_BLOCK_NUMBER];	/*512byte * SLT_TEST_BLOCK_NUMBER = 64K bytes*/
uint32_t slt_msdc_rx_buf[128 * 4 * 2];	/*512byte * SLT_TEST_BLOCK_NUMBER = 64K bytes*/

unsigned char sdio_tx_buff[BROM_BUFF_SIZE];
uint8_t whisr_enhance_reg[512];
uint32_t sdio_rx_buffer[BROM_BUFF_SIZE / 4];
struct mmc_card *mt7682_card;
struct sdio_func *mt7682_func;
static iot_dev_info_t iot_info;
struct iot_data *pMT7682_data ;
struct completion rx0_done;
struct completion rx1_done;


static u32 link_status = 0;

inline int sdio_func1_wr( unsigned int u4Register, void *pBuffer,  unsigned int Length)
{
    int ret ;

    /*addr 4-byte align check*/
    BUG_ON((((u32)pBuffer) & 0x03));
	BUG_ON(!mt7682_func);
	
	ret = sdio_writesb(mt7682_func,u4Register, pBuffer, Length);
	if (ret) {
        pr_err("[ERR] function 1 write fail : addr : 0x%x , size : %d, err_ret: 0x%x\r\n", u4Register, Length, ret) ;
    }
	return 0;
}

inline int  sdio_func1_rd( unsigned int u4Register, void *pBuffer,  unsigned int Length)
{
    int ret ;

	BUG_ON(!pBuffer);
	BUG_ON(!mt7682_func);

	ret = sdio_readsb(mt7682_func,pBuffer,u4Register, Length); 

    if (ret) {
        pr_err("[ERR] function 1 read fail : addr : 0x%x , size : %d, err_ret: 0x%x\r\n", u4Register, Length, ret) ;
    }

	return ret;
    
}

inline int hal_gpt_delay_ms(int ms)
{
	mdelay(ms);
	return 0;
}

bool h2d_send_mailbox(uint32_t cmd)
{
    uint32_t h2d_mb;

    if (0 != sdio_func1_wr(SDIO_IP_H2DSM0R, &cmd, 4)) {
        return false;
    }

    h2d_mb = SDIO_SWINT_MB0_BROMSEND;
    if (0 != sdio_func1_wr(SDIO_IP_WSICR, &h2d_mb, 4)) {
        return false;
    }

    return true;
}


static bool h2d_receive_mailbox( uint32_t *cmd)
{

#if 0
    do {
        wait_count++;
        mdelay(1);//msdc_wait(1);
        sdio_func1_rd(SDIO_IP_WHISR, &whisr, 4);
		
		pr_info("###h2d_receive_mailbox: whisr = %x\r\n",whisr);
    } while ((0 == (whisr & SDIO_SWINT_MB0_BROMRECV)) && (wait_count < 50));

    if (wait_count >= 50) {
        pr_warn("wait receive mailbox timeout!\r\n");
        return false;
    }
#endif
    if (0 != sdio_func1_rd(SDIO_IP_D2HRM0R, cmd, 4)) {
		
        return false;
    }


    return true;
}

#if 0
static bool h2d_send_mailbox(uint32_t cmd)
{
    uint32_t h2d_mb;

    if (0 != sdio_func1_wr(SDIO_IP_H2DSM0R, &cmd, 4)) {
        return false;
    }

    h2d_mb = SDIO_SWINT_MB0_BROMSEND;
    if (0 != sdio_func1_wr(SDIO_IP_WSICR, &h2d_mb, 4)) {
        return false;
    }

    return true;
}
#endif

static bool sdio_receive_pkt(hal_sdio_slave_rx_queue_id_t queue_id, uint8_t *rx_buf)
{
    uint32_t total_len = 0;
	uint32_t wrplr_reg = 0;	

    sdio_func1_rd(SDIO_IP_WRPLR, &wrplr_reg, 4);

	total_len = queue_id?(wrplr_reg>>16):(wrplr_reg&0xffff);

	if(total_len!=2048)
	{
		pr_warn("WARNING!! sdio_receive_pkt:total_len = %d\r\n",total_len);
	}

    if (sdio_func1_rd(queue_id?SDIO_IP_WRDR1:SDIO_IP_WRDR0, rx_buf, total_len)) {
        pr_err("[ERR],sdio_receive_pkt, sdio_func1_rd SDIO_IP_WRDR0 fail\r\n");
        return false;
    }

    return true;
}

//static 
static int sdio_send_pkt(unsigned char tx_que, uint8_t *tx_buf, int data_length)
{
#ifndef ENABLE_TX_IRQ
    uint32_t whisr_reg = 0;
    uint32_t wait_count = 0;

    do {
        sdio_func1_rd(SDIO_IP_WHISR, &whisr_reg, 4);

        wait_count++;

    } while ((0 == (whisr_reg & TX_DONE_INT)) && (wait_count < 5)); /*waiting TX_DONE_INT*/

    if (wait_count >= 5) {
        pr_err("wait TX done timeout!  whisr_reg = 0x%08x\r\n",whisr_reg);
		return -ETIME;
    }

	if(wait_count>2)
		pr_err("wait count:%d\r\n",wait_count);


    //Clear TX_DONE
    sdio_func1_rd(SDIO_IP_WTSR0, &whisr_reg, 4);
#endif


    if (sdio_func1_wr(SDIO_IP_WTDR1, tx_buf, data_length)) {
        pr_err("[ERR] sdio_send_pkt => sdio_func1_wr 0x%08x len=%d error\r\n", SDIO_IP_WTDR1, (data_length + sizeof(brom_sdio_tx_sdu_header_t)));
        return -1;
    }

    return 0;
}

static bool sdio_hif_get_driver_own(void)
{

    bool ret ;
    uint32_t value ;
    uint32_t cnt = 50;

    pr_info("[sdio_hif_get_driver_own]<==========>\r\n") ;

    //Set driver own
    value = W_FW_OWN_REQ_CLR ;
    if ((ret = sdio_func1_wr(SDIO_IP_WHLPCR, &value, 4)) != 0) {
        return false;
    }

    while (cnt--) {
        if ((ret = sdio_func1_rd(SDIO_IP_WHLPCR, &value, 4)) != 0) {
            return false ;
        }

        if (value & W_DRV_OWN_STATUS) {
            return true;
        }
    }

    return false;
}



static bool sdio_hif_enable_interrupt(void)
{
	uint32_t value ;

	value = W_INT_EN_SET; 

	if (0 != sdio_func1_wr(SDIO_IP_WHLPCR, &value, 4)){
		return -1 ; 
	}

	value = /*TX_DONE_INT |*/ RX0_DONE_INT | /*RX1_DONE_INT|*/SDIO_SWINT_MB0_BROMRECV; 
#ifdef ENABLE_RX1_INTERRUPT
	value |= RX1_DONE_INT; 
#endif

	if (0 != sdio_func1_wr(SDIO_IP_WHIER, &value, 4)){
		return -1 ; 
	}
	sdio_func1_rd(SDIO_IP_WHIER, &value, 4);
	pr_info("####sdio_hif_enable_interrupt: %x\r\n",value);

	if (0 != sdio_func1_rd(SDIO_IP_WHCR, &value, 4)){
		return -1 ; 
	}	

	value |= W_INT_CLR_CTRL;
	
	if (0 != sdio_func1_wr(SDIO_IP_WHCR, &value, 4)){
		return -1 ; 
	}	
	

	return 0;
}

static bool sdio_hif_disable_interrupt(void)
{
	uint32_t value ;

	value = W_INT_EN_CLR; 

	if (0 != sdio_func1_wr(SDIO_IP_WHLPCR, &value, 4)){
		return -1 ; 
	}

	value = 0x000000080;// |RX0_DONE_INT | /*RX1_DONE_INT|*/SDIO_SWINT_MB0_BROMRECV; 

	if (0 != sdio_func1_wr(SDIO_IP_WHIER, &value, 4)){
		return -1 ; 
	}

	return 0;
}


#ifdef IOT_ETH_DEBUG
static int sdio_get_cccr(struct mmc_card *card)
{
	int err_ret;
	u8 val;
	int i;
	u8 sdio_cccr_register[31];

	for(i=0;i<31;++i)
	{		
		val = sdio_f0_readb(card->sdio_func[0], i, &err_ret);

		//ret = sdio_f0_readb()
		if (err_ret)
			return err_ret;

		pr_info("sdio_cccr_register[%d] = %02x\r\n",i,val);
	}

	return 1;
}
#endif

#if 0
static bool sdio_irq_enable(void)
{
    uint32_t whier = 3;
    if (0 != sdio_func1_rd(SDIO_IP_WHIER, &whier, 4)) {
        return false;
    }
	whier |=3;

    if (0 != sdio_func1_wr(SDIO_IP_WHIER, &whier, 4)) {
        return false;
    }
#ifdef IOT_ETH_DEBUG
    if (0 != sdio_func1_rd(SDIO_IP_WHIER, &whier, 4)) {
        return false;
    }
	pr_info("sdio_irq_enable:WHIER = %x\r\n",whier);
#endif	
    return true;
}

static bool sdio_irq_disable(void)
{
    uint32_t whier = 3;
    if (0 != sdio_func1_rd(SDIO_IP_WHIER, &whier, 4)) {
        return false;
    }
	whier &=(~3);

    if (0 != sdio_func1_wr(SDIO_IP_WHIER, &whier, 4)) {
        return false;
    }
#ifdef IOT_ETH_DEBUG					
//debug	
    if (0 != sdio_func1_rd(SDIO_IP_WHIER, &whier, 4)) {
        return false;
    }
	pr_info("sdio_irq_disable:WHIER = %x\r\n",whier);
#endif	
    return true;
}
#endif

static inline int mt7682_write_data ( u32 data_type, void *data, int len)
{
	int status;
	static int seq = 0;
	iot_pkt_head_t *tx_pkt_headker =(iot_pkt_head_t *) &slt_msdc_tx_buf[2];
	char* p = (char*)&slt_msdc_tx_buf[2];

	
	slt_msdc_tx_buf[1]++;

	tx_pkt_headker->cmd = (u16)(data_type&0xffff);
	tx_pkt_headker->pkt_len = len;
	tx_pkt_headker->seq_num = seq++;
	p += sizeof(tx_pkt_headker);

	memcpy(p,data, len);

	sdio_claim_host(mt7682_func);

	status = sdio_send_pkt(0, (uint8_t *)slt_msdc_tx_buf, (512 * SLT_TEST_BLOCK_NUMBER)-4);
	if(status) {
		pr_err("mt7682_write_data error!\r\n");
	}

	sdio_release_host(mt7682_func); 
	return status;

}


static int mt7682_cmd_power_off(void)
{
	int ret;
	u32 mode = 0;
	
	pr_info("%s\r\n",__func__);	
	printk(KERN_INFO "Send power off command to MT7682\n");


	if((ret = mt7682_write_data( SPIS_CMD_SET_POWER_OFF, &mode,sizeof(mode)))<0)
		pr_err("failed to set power mode to MT7682 %d\n", ret);


	return 0;
}
 

static int
iot_eth_rx(struct net_device *dev)
{
	PIOT_SDIO_HOST host = (PIOT_SDIO_HOST)netdev_priv(dev);

#define OFFSET_DEST_MAC 12
#define PKT_SPI_RX_SIZE 1600
	struct sk_buff *skb;
	struct iot_rxinfo* pRxinfo;
	int rxlen = PKT_SPI_RX_SIZE;
	static int next_rx_pkt_seq;

	if (false == sdio_receive_pkt(HAL_SDIO_SLAVE_RX_QUEUE_0,(uint8_t *)slt_msdc_rx_buf)) {
		pr_err("4 sdio host receive error!\r\n");
		return -6;
	}

#if 0
	for(i=0;i<8;++i)
	{
		pr_info(" %d x%08x ",i, slt_msdc_rx_buf[i]);

	}
#endif
	if (!netif_running(dev))
		goto drop;	

	do {

		if((skb = dev_alloc_skb(rxlen+IOT_RX_INFO_SIZE+SPIM_HEADER_SIZE)) != NULL) {
			u8 *pRead;
			int i;			
			pRead = (u8 *) skb_put(skb, rxlen);

			memcpy(pRead, slt_msdc_rx_buf,rxlen);
			pRxinfo =(struct iot_rxinfo* ) pRead;
			
			if(pRxinfo->RxPktReady!=next_rx_pkt_seq)
			{
				pr_warn("RxPktReady: %d\r\n", pRxinfo->RxPktReady );	
			}
			next_rx_pkt_seq = pRxinfo->RxPktReady+1;

			if(pRxinfo->status !=0x55)
			{
				pr_warn("status: %d\r\n", pRxinfo->status );
				dev_kfree_skb(skb);
				
				return -1; 
			}

			pRxinfo->status = 0;
					
			rxlen = le16_to_cpu(pRxinfo->len);
#ifdef IOT_ETH_DEBUG
			if (netif_msg_rx_status(host)) {
  
				dev_info(host->dev, "RX: status %02x, length %04x\n",
					pRxinfo->status, rxlen);

			}
#endif		

			/* Packet Status check */
			if ((rxlen < 0x2a )||(rxlen > 1536)) {			
				if(rxlen!=0)
				{
						dev_warn(host->device, "RX: Bad Packet (runt). len = %d\n",rxlen);				
#ifdef IOT_ETH_DEBUG				
					if (netif_msg_rx_err(host))
						dev_info(host->dev, "RX: Bad Packet (runt). len = %d\n",rxlen);
#endif
#if 0
					dev->stats.rx_length_errors++;
					dev->stats.rx_errors++;
					dev->stats.rx_dropped++;
#endif					
				}
				dev_kfree_skb(skb);
				return 0;
			}
			
			if(rxlen<(0x2a+12))
				for(i=0;i<rxlen;++i)
				{
					pr_info(" %d %x ",i, pRead[i]);

				}
				
			dev->stats.rx_bytes += rxlen;

			skb_reserve(skb, IOT_RX_INFO_SIZE+SPIM_HEADER_SIZE);
			/* Pass to upper layer */
#if 0
			if (netif_running(ndev_eth1))
			{
				if(!memcmp(&pRead[OFFSET_DEST_MAC], dev->dev_addr ,ETH_ALEN))
				{
					skb->protocol = eth_type_trans(skb, dev);	
					netif_rx(skb);				
				}
				else if(!memcmp(&pRead[OFFSET_DEST_MAC], ndev_eth1->dev_addr, ETH_ALEN))
				{
					skb->protocol = eth_type_trans(skb, ndev_eth1); 
					netif_rx(skb);			
				}
				else if(!memcmp(&pRead[OFFSET_DEST_MAC], broadcast_addr,  ETH_ALEN))
				{
					struct sk_buff * ap_skb = skb_clone(skb, GFP_ATOMIC);	
					ap_skb->protocol = eth_type_trans(ap_skb, ndev_eth1);
					netif_rx(ap_skb);

					skb->protocol = eth_type_trans(skb, dev);	
					netif_rx(skb);			
					
				}
			}
			else
#endif				
			{
				skb->protocol = eth_type_trans(skb, dev);	
				netif_rx(skb);			
			}

			dev->stats.rx_packets++;
#if 0
			if(rxlen==226)
			{

				if (time_after(jiffies, jitter + 20)) {
					printk (KERN_ERR" rx jitter = %d len=%d\n",(int)(jiffies-jitter),rxlen);
				}

				jitter = jiffies;

				recv_num_pkts++;
				recv_data_size+=rxlen;

				if(rx_t==0 ||time_after(jiffies, rx_t+1*HZ))
				{
					rx_t = jiffies;
					printk(KERN_ERR"RX %d packets, %d Bytes %d bps\r\n",(int)recv_num_pkts-pre_recv_pkts, (int)recv_data_size,(int)((recv_data_size-pre_recv_size)*8));
					pre_recv_size = recv_data_size;
					pre_recv_pkts = recv_num_pkts;
				}			
			}
#endif			
		}
	}while(0);

	return 0;	
drop:	
	pr_info("Interface not ready that rx pkt is dropped!\r\n");
		
	return 0;
}


static inline int mt7682_read_data (u32 data_type, void *data, int len)
{

	//pr_info("%s: Data type = %d \r\n",__func__,data_type); 

	switch(data_type)
	{
		case SPIS_CMD_GET_INFO:
			sdio_claim_host(mt7682_func);			
			sdio_receive_pkt(HAL_SDIO_SLAVE_RX_QUEUE_1,(uint8_t *)&iot_info);	
			sdio_release_host(mt7682_func);

			//iot_info.status = link_status;

			memcpy(data,&iot_info, len);
			break;

		case SPIS_CMD_GET_LINK:
			{

				sdio_claim_host(mt7682_func);			
				sdio_receive_pkt(HAL_SDIO_SLAVE_RX_QUEUE_1,(uint8_t *)&iot_info);
				sdio_release_host(mt7682_func);				
			
				link_status = iot_info.status&0x84;			
				memcpy(data,&link_status,4);
			}
			break;
	}

	pr_info("IoT Device %s Info: \n", iot_info.name);
	pr_info("Status: 0x%02x\n", (int)iot_info.status);
	pr_info("MAC Addr: %02x:%02x:%02x:%02x:%02x:%02x \n",	iot_info.mac_addr[0],
															iot_info.mac_addr[1],
															iot_info.mac_addr[2],
															iot_info.mac_addr[3],
															iot_info.mac_addr[4],
															iot_info.mac_addr[5]);
	
	pr_info("netmask %x",iot_info.netmask);
	pr_info("gateway_addr %x",iot_info.gateway_addr);
	pr_info("DNS addr0 %x",iot_info.dns_addr[0]);
	pr_info("DNS addr1 %x",iot_info.dns_addr[1]);
	pr_info("RTC: %s",iot_info.rtc_str); 
	
	pr_info("opmode: 0x%02x\n", (int)iot_info.wifisetting.opmode);
	pr_info("ssid: %s\n",	iot_info.wifisetting.ssid);
	pr_info("psk: %s\n",	iot_info.wifisetting.psk);
	pr_info("auth: 0x%02x\n",	(int)iot_info.wifisetting.auth);
	pr_info("encrypt: 0x%02x\n",	(int)iot_info.wifisetting.encrypt);
	pr_info("reconnect: 0x%02x\n",	(int)iot_info.wifisetting.reconnect);
	return 0;
	
	
}



static inline int mt7682_send_eth_pkt ( u32 data_type, void *data, int len)
{
	int status;

	slt_msdc_tx_buf[1]++;
	memcpy(&slt_msdc_tx_buf[2],data, len);

		
	sdio_claim_host(mt7682_func);

	status = sdio_send_pkt(0, (uint8_t *)slt_msdc_tx_buf, (512 * SLT_TEST_BLOCK_NUMBER)-4);
	if(status!=0) {
		pr_err("5 sdio host send error!\r\n");
	}

	sdio_release_host(mt7682_func); 

	return status;


}

static int mt7682_send_eth_2_pkt(u32 data_type, void *data1, int len1, void* data2, int len2)
{
	int status;

	slt_msdc_tx_buf[1]++;
	memcpy(&slt_msdc_tx_buf[2],data1, len1);
	memcpy(&slt_msdc_tx_buf[(1536/4)],data2, len2);	

		
	sdio_claim_host(mt7682_func);

	status = sdio_send_pkt(0, (uint8_t *)slt_msdc_tx_buf, 1024*3);
	if(status!=0) {
		pr_err("5 sdio host send error!\r\n");
	}

	sdio_release_host(mt7682_func); 

	memset(&slt_msdc_tx_buf[2],0, 2);
	memset(&slt_msdc_tx_buf[(1536/4)],0, 2);	

	return status;


}

static int mt7682_set_wifi_config(iot_wifi_setting_t *wifisetting)
{
	int ret;

	if((ret = mt7682_write_data( SPIS_CMD_SET_WIFI, wifisetting,sizeof(iot_wifi_setting_t)))<0)
		pr_err("mtk_iot_set_wifi error %d\n", ret);

	return 0;
}


static int mt7682_get_wifi_config(iot_dev_info_t *dev_info)
{

//	unsigned long ret;
	
	printk(KERN_INFO "mt7682_get_wifi_config\n");
#if 0	
	sdio_claim_host(mt7682_func);			

	h2d_send_mailbox(SDIO_SWINT_MB0_CMD_REQ_WIFI_INFO);

//	iot_read_data( , info, (u32)sizeof(iot_dev_info_t));
//		pr_err("mtk_iot_set_wifi error %d\n", ret);

	sdio_release_host(mt7682_func);
	return 0;
	ret = wait_for_completion_timeout(&rx1_done, 10);
	if(ret)
		pr_info("mt7682_get_wifi_config: rx0 timeout = %d\r\n",ret);
	else
		pr_err("iot no response!");
#endif	

	memcpy(dev_info, &iot_info, sizeof(iot_dev_info_t) );


	return 0;
}

static int mt7682_get_mac(int eth_if, char* mac)
{

	memcpy(mac,&iot_info.mac_addr,6);	
	return 0;
}



/*******************************************************************/
/* SDIO callbacks                                                  */
/*******************************************************************/
int is_slave_tx_ready = 0;
int tx_count = 100;

void mt7682_sdio_interrupt(struct sdio_func *func)
{

	u32 whisr;
	PIOT_SDIO_HOST host = sdio_get_drvdata(func);
	struct net_device *ndev = host->ndev;
	
	sdio_claim_host(func);
    sdio_func1_rd(SDIO_IP_WHISR, &whisr, 4);


	//pr_info("###mt7682_sdio_interrupt: whisr = x%x\r\n",whisr);	

#ifdef ENABLE_TX_IRQ
	if(whisr&TX_DONE_INT)
	{
	
		u32 wtsr0;
	
		sdio_func1_rd(SDIO_IP_WTSR0, &wtsr0, 4);
		
	}
#endif
	if(whisr&RX0_DONE_INT)
	{		
//		pr_info("###RX#0 DONE!\r\n");
		iot_eth_rx(ndev);	
	}

	if(whisr&FW_OWN_BACK_INT)
	{	
		u32 value = FW_OWN_BACK_INT;
	    sdio_func1_wr(SDIO_IP_WHISR, &value, 4);
	}

#ifdef ENABLE_RX1_INTERRUPT

	if(whisr&RX1_DONE_INT)
	{

//		pr_info("###RX#1 DONE!\r\n");	
		uint8_t buf[2048];
		//void* p = (void*)&iot_info;

		if (false == sdio_receive_pkt(HAL_SDIO_SLAVE_RX_QUEUE_1,(uint8_t *)buf)) {
			pr_err("%s %d: sdio host receive error!\r\n",__func__, __LINE__);
			return;
		}

		memcpy((void*)&iot_info,buf, sizeof(iot_dev_info_t));

		pr_info("iot info is updated.");
		pr_info("name: %s\r\n",iot_info.name);	
		pr_info("mac: %02x:%02x:%02x:%02x:%02x:%02x:\r\n",iot_info.mac_addr[0],
															iot_info.mac_addr[1],
															iot_info.mac_addr[2],
															iot_info.mac_addr[3],
															iot_info.mac_addr[4],
															iot_info.mac_addr[5]);
		
		pr_info("ssid: %s\r\n",iot_info.wifisetting.ssid);	
		pr_info("psk: %s\r\n",iot_info.wifisetting.psk);			
		pr_info("auth: %d\r\n",iot_info.wifisetting.auth);
		pr_info("encrypt: %d\r\n",iot_info.wifisetting.encrypt);

		pr_info("status: %d\r\n",(int)iot_info.status);
		pr_info("ipaddr: x%08x\r\n",iot_info.ipaddr);

		memcpy(ndev->dev_addr,iot_info.mac_addr,ETH_ALEN);

	}
#endif
	if(whisr & SDIO_SWINT_MB0_BROMRECV)
	{
		volatile uint32_t  mail_value = 0;
		u32 value;
		h2d_receive_mailbox((uint32_t*)&mail_value);

	    value = SDIO_SWINT_MB0_BROMRECV;
	    sdio_func1_wr(SDIO_IP_WHISR, &whisr, 4);
	
		pr_info("###h2d_receive_mailbox: value = %d\r\n",mail_value);

		if(mail_value == 0x84 )
		{
			pr_info("netif_carrier_on");
			netif_carrier_on(ndev);
			iot_info.status = 0x84;
		}
		else
		{
			pr_info("netif_carrier_off");
			netif_carrier_off(ndev);
			iot_info.status = mail_value;
			
		}	

	}

	if(whisr & 0x40)
	{
		u32 wasr;	
		sdio_func1_rd(SDIO_IP_WASR, &wasr, 4);

		pr_info("###mt7682_sdio_interrupt: wasr = x%x\r\n",wasr); 

		if(wasr & RX0_UNDERFLOW)
		{
			pr_info("RX0_UNDERFLOW");
		}	
		if(wasr & RX1_UNDERFLOW)
		{
			pr_info("RX1_UNDERFLOW");
		}

		if(wasr & TX1_OVERFLOW)
		{
			pr_info("TX1_OVERFLOW");
		}

		if(wasr & TX0_OVERFLOW)
		{
			pr_info("TX0_OVERFLOW");
		}

		if(wasr & FW_OWN_INVALID_ACCESS)
		{
			pr_info("FW_OWN_INVALID_ACCESS");
		}
	}

	sdio_release_host(func);

}


static int mt7682_init(void* priv_data)
{
	int ret;
	tx_header *tx_buffer_header;
	uint32_t *tx_buffer;

	struct sdio_func *func = (struct sdio_func *)priv_data;

	mt7682_card = func->card;
	mt7682_func = mt7682_card->sdio_func[0];

	sdio_claim_host(func);

    memset(&slt_msdc_tx_buf, 0, sizeof(slt_msdc_tx_buf));
    tx_buffer_header = (tx_header *)slt_msdc_tx_buf;
    tx_buffer = slt_msdc_tx_buf;
    tx_buffer_header->length = 1024*3-4;
    tx_buffer += (sizeof(tx_header) / 4);

	slt_msdc_tx_buf[1] = 0;

	//if(sdio_is_initilized(func)!=2)	
	{	
		ret = sdio_enable_func(func);
		if (ret) {
			pr_err("mt7682_sdio: Failed to enable F1 Err: 0x%08x", ret);
			goto release;
		}
	
		ret = sdio_set_block_size(func, MT7682_SDIO_BLOCK_SIZE);
		if (ret)
			goto disable;

		ret = sdio_hif_get_driver_own();
		pr_info("sdio_hif_get_driver_own: ret = %d\r\n",ret) ;		
		if(ret!=1)
			goto disable;

		ret = sdio_hif_enable_interrupt();

		func->cur_blksize = MT7682_SDIO_BLOCK_SIZE;
		
		ret = sdio_claim_irq(func, mt7682_sdio_interrupt);
		if (ret)
		{
			pr_err("sdio claim irq fail!\r\n");
			goto release_irq;
		}		

	}
	sdio_release_host(func);

	init_completion(&rx0_done);
	init_completion(&rx1_done);	

	return 0;

	release_irq:		
		sdio_release_irq(func);
	disable:
		sdio_disable_func(func);
	release:
		sdio_release_host(func);

	sdio_release_host(func);		
	return ret;	
}
 
static int mt7682_close(void* priv_data)
{
	struct sdio_func *func = (struct sdio_func *)priv_data;
	sdio_claim_host(func);	
	sdio_hif_disable_interrupt();
	sdio_release_irq(func);
	sdio_release_host(func);
	return 0;
}

static struct sk_buff *
mt7682_fill_skb_header(struct net_device *ndev, struct sk_buff_head *q)
{

	struct sk_buff *skb, *tx_skb;
	iot_pkt_head_t *info;
	int headroom;
	int tailroom;
	u16 tol_len, pkt_len;
	u16 padlen;
	static u16 seq_num = 0;
	 
	static unsigned long pre_sent_size = 0;
	static unsigned long  sent_data_size = 0;
	static unsigned long sent_num_pkts = 0;
	static unsigned long t=0;

	if (skb_queue_empty (q)) {
		return NULL;
	}

	skb = skb_peek (q);
	pkt_len = skb->len;

	sent_data_size += pkt_len;
	sent_num_pkts++;
	if(t==0 ||time_after(jiffies, t+20*HZ))
	{
		t = jiffies;
		pr_info("Sent %d packets, %d Bytes %d bps\r\n",(int)sent_num_pkts, (int)sent_data_size,(int)(((sent_data_size-pre_sent_size)*8)/20));
		pre_sent_size = sent_data_size;
	}

	headroom = skb_headroom(skb);
	tailroom = skb_tailroom(skb);
	
	padlen = ((pkt_len + 3 ) & 0x7FC) - pkt_len;
	tol_len = ((pkt_len + 3 ) & 0x7FC) + TX_HEAD_SIZE + SPIM_HEADER_SIZE;
	seq_num++;

	info = (iot_pkt_head_t *) skb->cb;
	info->cmd = SPIS_CMD_ETH_PKT_TX;
	info->pkt_len = pkt_len;

	if ((!skb_cloned(skb)) &&
	    (headroom >= (TX_HEAD_SIZE)) &&
	    (tailroom >= (padlen))) {

		info->seq_num = seq_num;
		memcpy (skb_push (skb, TX_HEAD_SIZE), (void*)info, TX_HEAD_SIZE);

		/* Make 32-bit aligment */
		skb_put (skb, padlen);
		tx_skb = skb;
		skb_unlink(skb, q);

	} else {

		tx_skb = alloc_skb (tol_len, GFP_KERNEL);
		if (!tx_skb)
			return NULL;

		info->seq_num = seq_num;

		memcpy (skb_push (skb, TX_HEAD_SIZE), (void*)info, TX_HEAD_SIZE);

		memcpy (skb_put (tx_skb, tol_len),
				skb->data, tol_len);

		skb_unlink (skb, q);
		dev_kfree_skb (skb);
	}

	return tx_skb;
}


static struct iot_dev_ops mt7682_iot_ops ={

	.init = mt7682_init,
	.close= mt7682_close,		
	.get_mac = mt7682_get_mac,
	.read = mt7682_read_data,
	.write = mt7682_write_data,
	.eth_tx = mt7682_send_eth_pkt,
	.eth_tx_2_pkt =mt7682_send_eth_2_pkt,
	.set_wifi_config = mt7682_set_wifi_config,
	.get_wifi_config = mt7682_get_wifi_config,	
	.sleep = mt7682_cmd_power_off,
	.fill_skb_header = mt7682_fill_skb_header,

};

static int __init mt7682_sdio_ops_init(void)
{
	pr_info("mt7682_sdio_ops_init\r\n");

	register_iot_ops(&mt7682_iot_ops);
	return 0;
}

static void __exit mt7682_sdio_ops_exit(void)
{

}

module_init(mt7682_sdio_ops_init);
module_exit(mt7682_sdio_ops_exit);

